<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:include href="Filter%20Settings.xslt"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/category_summary.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/print.css" media="print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/filterSettings.css" media="screen,print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/tablesortCommon.css" media="screen,print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/zero_states.css" media="all" charset="utf-8" type="text/css" />

		<script type="text/javascript" src="../js/jquery-1.10.2.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/jquery.metadata.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/jquery.tablesorter.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/tablesorterParsers.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/categorySummary.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/taxSchedule.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/quickzoomTx.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/filterSettings.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>

		<script type="text/javascript">
function CategorySummaryInit() {
	TableSortInit("table.transactionEntry");
	InitDisclosures();
	ShowMeSetup();
	QuickZoomTransactionsInit();
	FilterSettingsInit(true);
}
	$(CategorySummaryInit);
		</script>
	</head>
	<body id="categorySummary">
		<div id="outerWrapper">
			<xsl:if test="count(currency/treeCollection)">
				<xsl:if test="summarizeByMode">
						<a href="" id="TXF" class="exportButton">Export TXF...</a>
				</xsl:if>
			</xsl:if>
			<xsl:apply-templates select="filterSettings"/>
			<div id="showMeMode">
				<table class="filterSettings additionalFilters">
					<tr>
						<td class="key">Type:</td>
						<td class="value">
							<ul>
								<li>
									Details for all categories
									<!-- Summary for all categories
									Top-level categories only
									Custom -->
								</li>
							</ul>
						</td>
					</tr>
					<xsl:if test="summarizeByMode">
						<tr>
							<td class="key">Tax Summary:</td>
							<td class="value">
								<ul>
									<li>
										<xsl:choose>
											<xsl:when test="summarizeByMode='schedule'">
												by Tax Schedule and Form
											</xsl:when>
											<xsl:when test="summarizeByMode='category'">
												by Category
											</xsl:when>
										</xsl:choose>
									</li>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
			<!-- Do we have any data? -->
			<xsl:choose>
				<xsl:when test="count(currency/treeCollection)">
					<!-- Display view selector only when data is present -->
					<xsl:if test="summarizeByMode">
						<div id="summarizeBy">
							<span>Summarize by: </span>
                            <div id="summarizeByWrapper">
                                <select id="summarizeBySelector" name="summarizeBy" onclick="SummarizeByDidChange(this)">
                                    <xsl:choose>
                                        <xsl:when test="summarizeByMode='schedule'">
                                            <option value="schedule" selected="yes">Tax Schedule/Form</option>
                                            <option value="category">Category</option>
                                        </xsl:when>
                                        <xsl:when test="summarizeByMode='category'">
                                            <option value="schedule">Tax Schedule/Form</option>
                                            <option value="category" selected="yes">Category</option>
                                        </xsl:when>
                                    </xsl:choose>
                                </select>
                                <div class="select_arrow_wrapper">
                                    <div class="arrow_up"></div>
                                    <div class="arrow_down"></div>
                                </div>
                            </div>
						</div>
					</xsl:if>
					<div id="viewAs">
						<select id="showMeSelector" name="viewAs" onclick="ViewAsDidChange(this, true)">
							<option value='showMe'>Update view to show me:</option>
							<option value='showAll'>Details for all categories</option>
							<option value='summary'>A summary of all categories</option>
							<option value='topOnly'>Top-level categories only</option>
						</select>
                        <div class="select_arrow_wrapper">
                            <div class="arrow_up"></div>
                            <div class="arrow_down"></div>
                        </div>
					</div>
					<xsl:apply-templates select="currency"/>
				</xsl:when>

				<xsl:otherwise>
					<!-- Begin: innerWrapper - NO data -->
					<div id="innerWrapperZeroDataCategory" class="fullWidth clearAfter">
						<div class="zeroState">
							<div class="noDataA">
								<p class="first">You have no transactions for the selected settings.</p>
								<p class="second">Try updating your settings above.</p>
							</div>
						</div>
					</div><!-- End: innerWrapper -->
                    <div class="treeCollection hide realizedGainLossWrapper">
                        <div class="collapsibleHeader scheduleDHeader opened">Schedule D</div>
                        <table class="scheduleDTable">
                            <tr class="tableHeaderRow">
                                <td class="security">Security</td>
                                <td class="shares">Shares</td>
                                <td class="dateAcquired">Date Acquired</td>
                                <td class="dateSold">Date Sold</td>
                                <td class="processds">Proceeds</td>
                                <td class="costBasis">Cost Basis</td>
                                <td class="gainLoss last">Gain/Loss</td>
                            </tr>
                        </table>
                    </div>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<!-- End: outerWrapper -->
	</body>
	</html>
</xsl:template>


<xsl:template match="currency">
	<xsl:if test="count(../currency)>1">
		<div class="currencyID"><xsl:value-of select="@title"/> (<xsl:value-of select="@currencyID"/>)</div>
	</xsl:if>

	<xsl:if test="count(treeCollection)">
		<!-- Begin: innerWrapper - WITH data -->
		<div id="innerWrapper" class="fullWidth clearAfter">
			<div class="showNotes"><input type="checkbox" name="showNotes" onclick="ShowNotesDidChange(this)" checked="true"/> Show Memo/Notes</div>
			<xsl:apply-templates select="treeCollection"/>

			<xsl:apply-templates select="netTotal"/>
		</div><!-- End: innerWrapper -->
	</xsl:if>
		
	<div class="treeCollection hide realizedGainLossWrapper">
		<div class="collapsibleHeader scheduleDHeader opened">Schedule D</div>
        <table class="scheduleDTable">
            <tr class="tableHeaderRow">
                <td class="security">Security</td>
                <td class="shares">Shares</td>
                <td class="dateAcquired">Date Acquired</td>
                <td class="dateSold">Date Sold</td>
                <td class="processds">Proceeds</td>
                <td class="costBasis">Cost Basis</td>
                <td class="gainLoss last">Gain/Loss</td>
            </tr>
        </table>
	</div>

	<xsl:if test="count(infoCollection)">
		<xsl:apply-templates select="infoCollection"/>
	</xsl:if>
</xsl:template>


<xsl:template match="treeCollection">
	<ul class="treeCollection">
		<xsl:apply-templates select="tagTree"/>
	</ul>
</xsl:template>

<xsl:template match="infoCollection">
	<ul class="treeCollection">
		<xsl:apply-templates select="tagTree"/>
	</ul>
</xsl:template>


<xsl:template match="netTotal">
	<div id="netTotals" class="fullWidth clearAfter">
		<table class="" cellspacing="0" cellpadding="0">
			<tr class="netSubTotal">
				<td class="netItem">Money In: </td>
				<td class="netValue" id="moneyInValue"><xsl:value-of select="inFlow"/></td>
			</tr>
			<tr class="netSubTotal">
				<td class="netItem">Money Out: </td>
				<td class="netValue netNegative" id="moneyOutValue"><xsl:value-of select="outFlow"/></td>
			</tr>
		</table>
		<div class="netDiv" />
		<table class="" cellspacing="0" cellpadding="0">
			<tr class="netTotal">
				<td class="netItem">Net Total: </td>
				<xsl:choose>
					<xsl:when test="total[@sign='negative']">
						<td class="netValue netNegative" id="netValue"><xsl:value-of select="total"/></td>
					</xsl:when>
					<xsl:otherwise>
						<td class="netValue" id="netValue"><xsl:value-of select="total"/></td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
		</table>
	</div>
</xsl:template>


<xsl:template match="tagTree">
	<xsl:variable name="tagTreeType">
		<xsl:if test="count(ancestor::tagTree)=0">topLevel</xsl:if>
	</xsl:variable>

	<li class="tag clearAfter {$tagTreeType}">
		<div class="tagHeader closed {$tagTreeType}" quickenid="{@quickenID}">
			<div class="tagHeaderRow {$tagTreeType}">
				<xsl:choose>
					<xsl:when test="total[@sign='negative']">
						<span class="tagTotal negative" id="tagTotal_{@name}"><xsl:value-of select="total"/></span>
					</xsl:when>
					<xsl:otherwise>
						<span class="tagTotal" id="tagTotal_{@name}"><xsl:value-of select="total"/></span>
					</xsl:otherwise>
				</xsl:choose>

				<span class="tagName {$tagTreeType}"><xsl:value-of select="@name"/></span>
			</div>
			<div class="collapsible clearAfter">
				<!-- HIding column  headers for now
				<xsl:if test="count(ancestor::tagTree)=0">
					<table cellspacing="0" cellpadding="0" border="0" class="topLevelHeader"><thead><tr>
						<th class='dateHeader {{sorter: "{/root/dateSort}"}}'>Date</th>
						<th class='accountHeader'>Account</th>
						<th class='payeeHeader'>Payee</th>
						<th class='amountHeader currency {{sorter: "qCurrency"}}'>Amount</th>
					</tr></thead></table>
				</xsl:if> -->
				<xsl:if test="count(transactionEntry)">
					<table class="transactionEntry" cellspacing="0" cellpadding="0">
						<xsl:apply-templates select="transactionEntry"/>
					</table>
				</xsl:if>
				<xsl:if test="count(tagTree)">
					<ul class="treeCollection">
						<xsl:apply-templates select="tagTree"/>
					</ul>
				</xsl:if>
			</div>
		</div>
	</li>
</xsl:template>

<xsl:template match="transactionEntry">
	<tr id="transaction_{@quickenID}" class="transactionRow" quickenid="{@quickenID}">
		<td class="date" id="transDate_{@quickenID}"><xsl:value-of select="date"/></td>
		<xsl:choose>
			<xsl:when test="transPayee">
				<td class="transPayee" id="transAccount_{@quickenID}"><xsl:value-of select="transPayee"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="account" id="transAccount_{@quickenID}"><xsl:value-of select="account"/></td>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(tags)">
				<td class="payee" id="tag_{@quickenID}"><xsl:value-of select="tags"/></td>
			</xsl:when>
			<xsl:when test="transAccounts">
				<td class="transAccounts" id="transPayee_{@quickenID}"><xsl:value-of select="transAccounts"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="payee" id="transPayee_{@quickenID}"><xsl:value-of select="payee"/></td>
			</xsl:otherwise>
		</xsl:choose>
		<td class="note" id="transNote_{@quickenID}"><xsl:value-of select="note"/></td>
		<xsl:choose>
			<xsl:when  test="amount[@sign='negative']">
				<td class="amount negative" id="transAmount_{@quickenID}"><xsl:value-of select="amount"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="amount" id="transAmount_{@quickenID}"><xsl:value-of select="amount"/></td>
			</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>


<xsl:template match="dateSort" />

</xsl:stylesheet>
